![Cheapindex logo](https://anyplanet.org/cheapindex/assets/CheapIndex-logo.png)

Looking for a fast, plug&play, one-page script for a wiki, landing page or README?

### CheapIndex offers
- PHP-based: works with older versions
- Create and update content effortlessly: one single [markdown](https://www.markdownguide.org/basic-syntax/) file
- Drag and drop setup: No installation
- Zero dependencies: no Composer, no libraries or frameworks required
- Responsive design: built with [PicoCSS](https://picocss.com/) for a sleek, modern look on any device
- Lightweight and easy to deploy: open source

### Just do
1. Download → [https://anyplanet.org/cheapindex/latest.zip](https://anyplanet.org/cheapindex/latest.zip)
2. Unzip and edit → configure settings in index.php and write content in index.md
3. Drop files → place both files in your target directory

### File permissions
Check that the permissions are correct
```
# Set permissions
chmod 644 index.php

# Set owner (replace 'youruser' with your username)
chown youruser:www-data index.md

# Give owner and group write permission
chmod 664 index.md
```

### Settings "all what you need" 
The most common settings and the style file are located in the CheapIndex Basic version’s index.php as PHP variables. Of course, you can edit the entire file freely. It’s a script and open source.

### Set basics
Set the basic page information in the meta fields. Social media meta tags (Open Graph tags) can be adjusted further down in the script. The default template includes "Made with CheapIndex" branding.
```
$set_title = 'Made with CheapIndex - A script for landing page, wiki, readme';
$set_description = 'Grab it now and get to work';
$site_author = 'CheapIndex';
$site_name = 'CheapIndex';
$set_keywords = 'CheapIndex, markdown to HTML, landing page, static site, wiki, parser';
$site_language = 'en';
$favicon_url = 'https://anyplanet.org/cheapindex/assets/favicon.ico';
```

### Set page typography and background color
You can use most of the fonts offered by [Google Fonts](https://fonts.google.com). Set your font by assigning its name (Ubuntu, Lato, Inter) to the $set_font variable. 'sans-serif' will be used by default. The page background color is changed using HTML color code.
```
$set_font = 'Lato';
$set_backgroundcolor = '#e6f2ff';
```

### Set time format and default timezone
The page footer shows the timestamp of when the content (index.md) was last updated. With these settings, you can override the Unix timestamp and set a custom timezone. For more information [php.net/date](https://php.net/date/)
```
$dateFormat = 'd M Y H:i';
date_default_timezone_set('Europe/Helsinki');
```

### Customize footer
These variables allow you to modify the information shown in the footer
```
$print_timezone_footer = 'EEST, UTC+3';
$print_contact_footer = 'Contact: info at anyplanet.org';
```

### Social media sharing
Configure a stylish social media preview image. CheapIndex placeholder by default
```
$set_social_media_preview = 'https://anyplanet.org/cheapindex/assets/Made-with-CheapIndex-social-media-preview.png';
```


### Coder's delight. Code snippets you actually need
You can enable line numbers for code blocks by setting true/false
```
$enable_line_numbers = true;
```

### The future is bright
More exciting features coming and a Premium version. Stay tuned
