
<?php

// ---- SETTINGS STARTS ----


// Set the basic page information in the meta fields. Social media variables (Facebook, LinkedIn, X) can be adjusted further down in the script.

    $set_title = 'Made with CheapIndex - A script for landing page, wiki, readme';
    $set_description = 'Grab it now and get to work';
    $site_author = 'CheapIndex';
    $site_name = 'CheapIndex';
    $set_keywords = 'CheapIndex, markdown to HTML, landing page, static site, wiki, parser';
    $site_language = 'en';
    $favicon_url = 'https://anyplanet.org/cheapindex/assets/favicon.ico';


//  Set time format and default timezone. The page footer shows the timestamp of when the content (index.md) was last updated. With these settings, you can override the Unix timestamp and set a custom timezone.. 

    $dateFormat = 'd M Y H:i';
    date_default_timezone_set('Europe/Helsinki');


//  Set page typography and background color. You can use Google Fonts. Set your font by assigning its name (Ubuntu, Lato, Inter) to the $set_font variable. sans-serif will be used by default. The page background color is changed using HTML color code.

    $set_font = 'Lato';
    $set_backgroundcolor = '#e6f2ff';


// Customize footer. These variables allow you to modify the information shown in the footer

    $print_timezone_footer = 'EEST, UTC+3';
    $print_contact_footer = 'Contact: info at anyplanet.org';


// Social media
    $set_social_media_preview = 'https://anyplanet.org/cheapindex/assets/Made-with-CheapIndex-social-media-preview.png';


// Code snippets you actually need. You can enable line numbers for code blocks by setting true/false

    $enable_line_numbers = false;


// ---- SETTINGS ENDS --


$markdownFile = 'index.md';

if (!file_exists($markdownFile)) {
    die('Markdown-tiedostoa ei löytynyt.');
}

$markdown = file_get_contents($markdownFile);

// Hae index.md-tiedoston viimeinen muokkausaika
$lastModified = date($dateFormat, filemtime($markdownFile));

// Käsitellään rivit erikseen
$lines = explode("\n", $markdown);
$html = '';
$listOpen = false;
$olOpen = false;
$inCodeBlock = false;
$codeBlockContent = '';

foreach ($lines as $line) {
    $trimmedLine = trim($line);

    // Koodilohko alkaa tai loppuu
    if (preg_match('/^```/', $line)) {
        if (!$inCodeBlock) {
            $inCodeBlock = true;
            $codeBlockContent = '';
        } else {
            // Lisää rivinumerot jos asetus on päällä
            if ($enable_line_numbers) {
                $codeLines = explode("\n", trim($codeBlockContent));
                $numberedCode = '';
                foreach ($codeLines as $index => $codeLine) {
                    $lineNum = $index + 1;
                    $numberedCode .= '<span class="line-number">' . $lineNum . '</span>' . htmlspecialchars($codeLine) . "\n";
                }
                $html .= "<pre><code>" . $numberedCode . "</code></pre>\n";
            } else {
                $html .= "<pre><code>" . htmlspecialchars($codeBlockContent) . "</code></pre>\n";
            }
            $inCodeBlock = false;
            $codeBlockContent = '';
        }
        continue;
    }

    // Jos ollaan koodilohkon sisällä
    if ($inCodeBlock) {
        $codeBlockContent .= $line . "\n";
        continue;
    }

    // Otsikot
    if (preg_match('/^### (.*)/', $trimmedLine, $matches)) {
        $html .= "<h3>{$matches[1]}</h3>\n";
    } elseif (preg_match('/^## (.*)/', $trimmedLine, $matches)) {
        $html .= "<h2>{$matches[1]}</h2>\n";
    } elseif (preg_match('/^# (.*)/', $trimmedLine, $matches)) {
        $html .= "<h1>{$matches[1]}</h1>\n";

    // Numeroitu lista
    } elseif (preg_match('/^\d+\.\s+(.*)/', $trimmedLine, $matches)) {
        if (!$olOpen) {
            $html .= "<ol>\n";
            $olOpen = true;
        }
        $html .= "<li>{$matches[1]}</li>\n";

    // Bullet lista
    } elseif (preg_match('/^(\-|\*)\s+(.*)/', $trimmedLine, $matches)) {
        if (!$listOpen) {
            $html .= "<ul>\n";
            $listOpen = true;
        }
        $html .= "<li>{$matches[2]}</li>\n";

    // Kuva
    } elseif (preg_match('/^!\[(.*?)\]\((.*?)\)/', $trimmedLine, $matches)) {
        $html .= "<img src=\"{$matches[2]}\" alt=\"{$matches[1]}\" class=\"img-fluid\">\n";

    // Tyhjä rivi
    } elseif (trim($line) === '') {
        if ($listOpen) {
            $html .= "</ul>\n";
            $listOpen = false;
        }
        if ($olOpen) {
            $html .= "</ol>\n";
            $olOpen = false;
        }
        $html .= "<br>\n";

    // Normaali kappale
    } else {
        $html .= "<p>$line</p>\n";
    }
}

// Listojen sulkeminen lopussa
if ($listOpen) $html .= "</ul>\n";
if ($olOpen) $html .= "</ol>\n";


// Inline-muotoilut  <-- TÄSSÄ
$inline = [
    '/\*\*(.*?)\*\*/s'        => '<strong>$1</strong>',
    '/\*(.*?)\*/s'            => '<em>$1</em>',
    '/\`(.*?)\`/s'            => '<code>$1</code>',
    '/!\[(.*?)\]\((.*?)\)/s'  => '<img src="$2" alt="$1" class="img-fluid">',
    '/\[(.*?)\]\((.*?)\)/s'   => '<a href="$2">$1</a>',
];

$html = preg_replace(array_keys($inline), array_values($inline), $html);

// Tämä luo facebook urlin

$link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']
              === 'on' ? "https" : "http") . "://" . 
              $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);

// Varmista että lopussa on / eikä tule tuplaviivoja
$link = rtrim($link, '/') . '/';

?>

<?php
// Hae nykyinen URL
$current_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . 
               "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
?>

<!DOCTYPE html>
<html lang="fi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta http-equiv="content-language" content="<?php echo $site_language; ?>">

    <title><?php echo $set_title; ?></title>
    <meta name="author" content="<?php echo $site_author; ?>">
    <meta name="description" content="<?php echo $set_description; ?>">
    <meta name="keywords" content="<?php echo $set_keywords; ?>">
    <meta name="robots" content="index, follow">

    <meta property="og:title" content="<?php echo $set_title; ?>">
    <meta property="og:description" content="<?php echo $set_description; ?>">
    <meta property="og:image" content="<?php echo $set_social_media_preview;; ?>">
    <meta property="og:image:alt" content="Made with CheapIndex">
    <meta property="og:url" content="<?php echo $link;; ?>">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo $site_name; ?>">
    <meta property="fb:app_id" content="">

    <meta name="twitter:title" content="<?php echo $set_title; ?>">
    <meta name="twitter:description" content="<?php echo $set_description; ?>">
    <meta name="twitter:card" content="<?php echo $set_social_media_preview;; ?>">

    <link rel="icon" href="<?php echo $favicon_url; ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@picocss/pico@2/css/pico.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=<?php echo $set_font; ?>&display=swap" rel="stylesheet">

    <style>


        .container {
            max-width: 960px;
            padding-top: 1rem;
        }
        body {
            color: #000;
            background-color: <?php echo (strpos($set_backgroundcolor, '#') === 0 ? $set_backgroundcolor : '#' . $set_backgroundcolor); ?>;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            font-family: "<?php echo $set_font; ?>", sans-serif;
            font-optical-sizing: auto;
            font-weight: 400;
            font-style: normal;
        }
        main {
            flex-grow: 1;
        }
        a {
            color: #000;
            text-decoration: underline;
        }
        a:hover {
            text-decoration: underline;
            opacity: 0.8;
        }
        footer {
            margin-top: 2rem;
            padding: 1rem 0;
            text-align: center;
            font-size: 0.9em;
        }
        footer a {
            color: #000;
            text-decoration: underline;
        }
        footer img {
            height: 20px;
            vertical-align: middle;
            margin-right: 0.5rem;
        }
        .img-fluid {
            max-width: 100%;
            height: auto;
            margin-bottom: 1.5rem;
            margin-top: 0;
        }
        p {
            margin-top: 0;
            margin-bottom: 0.1rem;
        }
        ul, ol {
            margin-top: 0;
            margin-bottom: 0.1rem;
        }
        li {
            margin-bottom: 0.1rem;
        }
        h3 {
            margin-top: 0;
            margin-bottom: 0.2rem;
        }
        pre {
            background-color: #f5f5f5;
            border: 1px solid #ddd;
            border-radius: 4px;
            padding: 1rem;
            overflow-x: auto;
            margin: 1rem 0;
        }
        code {
            background-color: #f5f5f5;
            padding: 0.2rem 0.4rem;
            border-radius: 3px;
            font-family: 'Courier New', Courier, monospace;
            font-size: 0.9em;
        }
        pre code {
            background-color: transparent;
            padding: 0;
            border-radius: 0;
        }
        .line-number {
            display: inline-block;
            width: 2.5em;
            margin-right: 1em;
            text-align: right;
            color: #999;
            user-select: none;
            border-right: 2px solid #777;
            padding-right: 0.5em;
        }
    </style>
</head>
<body>
    <main class="container">
        <?php echo $html; ?>

<div style="margin: 1rem 0;">
    <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode($current_url); ?>" target="_blank" style="display: inline-block; padding: 0.3rem 0.6rem; background-color: #0077B5; color: white; text-decoration: none; border-radius: 3px; margin-right: 0.5rem; font-size: 0.85em;">
       <svg style="width: 18px; height: 18px; vertical-align: middle; margin-right: 0.3rem;" fill="currentColor" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg>
       Share on LinkedIn
    </a>
    
    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($current_url); ?>" target="_blank" style="display: inline-block; padding: 0.3rem 0.6rem; background-color: #1877F2; color: white; text-decoration: none; border-radius: 3px; margin-right: 0.5rem; font-size: 0.85em;">
       <svg style="width: 18px; height: 18px; vertical-align: middle; margin-right: 0.3rem;" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
       Share on Facebook
    </a>
    
    <a href="https://teams.microsoft.com/share?href=<?php echo urlencode($current_url); ?>" target="_blank" style="display: inline-block; padding: 0.3rem 0.6rem; background-color: #6264A7; color: white; text-decoration: none; border-radius: 3px; font-size: 0.85em;">
       <svg style="width: 18px; height: 18px; vertical-align: middle; margin-right: 0.3rem;" fill="currentColor" viewBox="0 0 24 24"><path d="M20.625 8.127v7.746a1.124 1.124 0 01-1.875.844l-2.813-2.531v4.688A1.126 1.126 0 0115 19.999H4.875A1.126 1.126 0 013.75 18.874V8.127A1.126 1.126 0 014.875 7h10.126A1.126 1.126 0 0116 8.127v4.688l2.813-2.531a1.124 1.124 0 011.875.844zm-7.5 2.813h-2.25v2.25h2.25v-2.25zm0-3.375h-2.25v2.25h2.25V7.565zm-3.75 3.375h-2.25v2.25h2.25v-2.25zm0-3.375h-2.25v2.25h2.25V7.565z"/></svg>
       Share on Teams
    </a>
</div>

    </main>
        <footer>
            Last modified: &nbsp; <?php echo $lastModified; ?> <?php echo $print_timezone_footer; ?><br>
            Made with <a href="https://anyplanet.org/cheapindex" target="_blank">CheapIndex</a> &nbsp; | &nbsp; <?php echo $print_contact_footer; ?>
    </footer>
</body>
</html>